﻿/// <reference path="jquery-1.3.2-vsdoc.js" />
/// <reference name="MicrosoftAjax.debug.js" />

var updatingItinerary = false;

// itinerary first-load
Sys.Application.add_init(function () {
    // init templates
    $create(Sys.UI.DataView, null, null, null, $get("itineraryDynamicList"));
    $create(Sys.UI.DataView, null, null, null, $get("itineraryError"));

    updateModel(baseUrl + 'Itineraries/Current', null, activityActionRequest, activityActionResponse);

    // first time bind
    onSearchResultsBound();

    // 'new' itinerary link
    $("#itinerary form.new").each(
        function (item, ix) {
            // remove onclick event and manually call confirmation dialog when needed
            var confirmationFunc = this.onsubmit;
            delete this.onsubmit;
            this.onsubmit = function () {
                if (confirmationFunc()) {
                    updateModel(this.action, $(this).serialize(), activityActionRequest, activityActionResponse);
                    $("#itinerarySave input[name=name]").val("");
                }

                return false;
            }
        }
    );

    // window.onerror = function () { reloadItinerary(); };
});

function reloadItinerary() {
}

// callback for when search results get binded (called from in ajax.search.js)
function onSearchResultsBound(container) {

    if (!container) container = $(".searchResults");

    updateModelOnClickLink($("ul.activities li .options a.add"), activityActionRequest, activityActionResponse);

    container.find("ul.activities li .handler").css("display", "")
        .bind("mousedown", function(e) {
            disableSelection(this);
            e.stopPropagation();
            if(updatingItinerary) return;
            updatingItinerary = true;            

            var el = $(this);
            var pos = el.position();
            while (!el.is("li")) el = el.parent();
            el = el.clone();
            el.find(".rating").remove();
            el.draggable({
                refreshPosition: true,
                scroll: true,
                connectToSortable: "#itineraryDynamicList",
                start: function(ev, ui) {
                    $(this).show();
                },
                stop: function(ev, ui) {
                    $(this).remove();
                }
            });
            el.hide().css("position", "absolute").css("top", pos.top).css("left", pos.left).addClass("clone");
            el.appendTo($("#temporalActivities"));
            el.simulate("mousedown", [e.originalEvent]);
            
        });

    function disableSelection(target) {
        if (typeof target.onselectstart != "undefined") //IE route
            target.onselectstart = function() { return false }
        else if (typeof target.style.MozUserSelect != "undefined") //Firefox route
            target.style.MozUserSelect = "none"
        else //All other route (ie: Opera)
            target.onmousedown = function() { return false }
        target.style.cursor = "default"
    }
}

// add to itinerary - intercept calls
var itineraryScrollPos = 0;
function activityActionRequest(url) {
    updatingItinerary = true;
    itineraryScrollPos = $("#itinerary .items").scrollTop();
    $("#itineraryDynamic .items").addClass("loading");
    return true;
}

function activityActionResponse(data) {
    
    // remove static
    $("#itinerary .static").remove();
    $("#itineraryDynamic").removeClass("off");
    
    // show dynamic
    $("#itineraryDynamic .items").removeClass("loading");
    $("#itineraryDynamic ul.activities").show();

    if (data.Status && data.Status == "error") {
        // error
        $find("itineraryError").set_data(data);
        updateModelOnClickLink($("#itineraryError a.retry"), activityActionRequest, activityActionResponse);
        $("#itineraryError").removeClass("off");
    } else {
        $("#itineraryError").addClass("off");
    }

    // bind
    $find("itineraryDynamicList").set_data(data.Activities);
    
    // intercept dynamic links
    updateModelOnClickLink($("#itineraryDynamic ul.activities li a.remove"), activityActionRequest, activityActionResponse);
    updateModelOnFormSubmit($("#itineraryDynamic ul.activities li form.estimatedMinutes"), activityActionRequest, activityActionResponse);

    // sortable
    makeActivitiesSortable();

    // empty / nonempty
    var data = $find("itineraryDynamicList").get_data();
    if (data.length == 0) {
        $("#itinerary .toolbox .pager").hide();
        $("#itinerary .empty").show();
    } else {
        $("#itinerary .toolbox .pager").show();
        $("#itinerary .empty").hide();
    }

    // scroll
    $("#itinerary .items").scrollTop(itineraryScrollPos);

    // total estimated time
    var estimatedContainer = $("#totalEstimatedTime");
    var total = 0;
    if (data.length != 0) {
        for (var i = 0; i < data.length; i++) {
            total += data[i].EstimatedMinutes;
        }
    }

    var text = '';
    if (total > 0) {
        var hours = Math.floor(total / 60);
        var minutes = total % 60;
        if (hours > 0) {
            text = hours + 'h ';
        }

        if (minutes > 0) {
            text += minutes + 'm';
        }
    }
    else {
        text = '-'
    }

    estimatedContainer.text(text);
    
    updatingItinerary = false;
}

function makeActivitiesSortable() {
    var startPosition;
    $("#itineraryDynamicList .handler").css("display", ""); // show handlers

    $("#itineraryDynamicList").sortable({
        placeholder: "ui-state-highlight",
        revert: true, revertTime: 250,
        forcePlaceholderSize: true,
        handle: ".handler",
        start: function (e, ui) {
            el = ui.item;
            startPosition = $(el).parent().children().index(el);
        },
        stop: function (e, ui) {
            try {
                el = ui.item;
                var activityId = $(el).find("span.id").text();
                var position = $(el).parent().children().index(el);
                if (el.is(".clone")) {
                    // on drop new
                    $(".clone").remove();
                    $("#itineraryDynamicList").sortable("refresh");
                    var link = $(el).find("p.options a.add").attr("href") + "&index=" + position;
                    updateModel(link, null, activityActionRequest, activityActionResponse);
                } else {
                    // on sort
                    if (position != startPosition) {
                        var link = $(el).find("p.options span.handler").attr("href");
                        link = replaceQueryString(link, "index", position);
                        updateModel(link, null, function () { return true; }, function () { });
                    }
                }
            } catch (er) {}
        }
    });

    $("#itineraryDynamicList").disableSelection();
}

// converters
function itineraryRatingConverter(value) {
    var val = (Math.round((value * 2)) / 2).toString();
    if (val % 1 == 0) {
        return val.toString() + ".0";
    } else {
        return val.toString()
    }
}